/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.config;

import frc.emul.config.Configuration;
import frc.emul.config.IndentedPrinter;
import frc.emul.config.data.CfgItemAuthor;
import frc.emul.config.data.CfgItemBankMenu;
import frc.emul.config.data.CfgItemCartridge;
import frc.emul.config.data.CfgItemCartridgeComposite;
import frc.emul.config.data.CfgItemCartridgePart;
import frc.emul.config.data.CfgItemCategory;
import frc.emul.config.data.CfgItemChassis;
import frc.emul.config.data.CfgItemController;
import frc.emul.config.data.CfgItemCurve;
import frc.emul.config.data.CfgItemGame;
import frc.emul.config.data.CfgItemGameContainer;
import frc.emul.config.data.CfgItemGameInfo;
import frc.emul.config.data.CfgItemJoystick;
import frc.emul.config.data.CfgItemKernel;
import frc.emul.config.data.CfgItemKey;
import frc.emul.config.data.CfgItemKeySwitch;
import frc.emul.config.data.CfgItemKeymapping;
import frc.emul.config.data.CfgItemOptions;
import frc.emul.config.data.CfgItemOverlay;
import frc.emul.config.data.CfgItemPeripheral;
import frc.emul.config.data.CfgItemRom;
import frc.emul.config.data.CfgItemSensitivity;
import frc.emul.config.data.CfgItemSeparator;
import frc.emul.config.data.CfgItemShaderGlow;
import frc.emul.config.data.CfgItemTiming;
import frc.emul.config.data.DevOptions;
import frc.emul.util.AttributesMap;
import frc.emul.util.Utils;
import frc.util.xml.XmlUtils;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;

public class ConfigSaver {
    private static final boolean READ_ONLY = false;

    public static final boolean save(Configuration configuration, String string) {
        if (string == null || string.length() == 0) {
            System.err.println("*** Error : no configuration filename provided, aborting!");
            return false;
        }
        FileOutputStream fileOutputStream = null;
        File file = null;
        File file2 = new File(string);
        boolean bl = false;
        if (file2.isFile()) {
            file = new File(String.valueOf(string) + ".tmp-backup");
            try {
                if (!(!file.exists() || file.isFile() && file.delete())) {
                    file = null;
                }
                if (file != null && !file2.renameTo(file)) {
                    file = null;
                }
            }
            catch (Exception exception) {
                file = null;
            }
        }
        try {
            try {
                fileOutputStream = new FileOutputStream(string);
            }
            catch (Exception exception) {}
            if (fileOutputStream == null) {
                System.err.println("*** Error while opening configuration file [" + string + "] for writing");
            } else {
                try {
                    bl = ConfigSaver.save(configuration, fileOutputStream);
                }
                catch (Exception exception) {
                    System.err.println("*** Error while saving configuration file [" + string + "]");
                    exception.printStackTrace(System.err);
                }
            }
        }
        catch (Throwable throwable) {
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (Exception exception) {}
            if (file != null) {
                if (bl) {
                    try {
                        file.delete();
                    }
                    catch (Exception exception) {}
                } else {
                    try {
                        Utils.copy(file, file2);
                        file.delete();
                    }
                    catch (Exception exception) {}
                }
            }
            throw throwable;
        }
        try {
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (Exception exception) {}
        if (file != null) {
            if (bl) {
                try {
                    file.delete();
                }
                catch (Exception exception) {}
            } else {
                try {
                    Utils.copy(file, file2);
                    file.delete();
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }

    public static final boolean save(Configuration configuration, OutputStream outputStream) throws IOException {
        PrintStream printStream = new PrintStream(outputStream, true, "UTF-8");
        IndentedPrinter indentedPrinter = new IndentedPrinter(printStream);
        try {
            ConfigSaver.saveXmlHeader(indentedPrinter);
            indentedPrinter.println("<configuration version=\"3\">");
            indentedPrinter.println();
            indentedPrinter.push();
            ConfigSaver.saveWindow(configuration, indentedPrinter);
            ConfigSaver.saveTiming(configuration, indentedPrinter);
            ConfigSaver.saveOptions(configuration, indentedPrinter);
            ConfigSaver.saveOverall(configuration, indentedPrinter);
            ConfigSaver.saveDisplay(configuration, indentedPrinter);
            ConfigSaver.saveKeyMapping(configuration, indentedPrinter);
            ConfigSaver.saveControllers(configuration, indentedPrinter);
            ConfigSaver.savePeripherals(configuration, indentedPrinter);
            ConfigSaver.saveCategories(configuration, indentedPrinter);
            ConfigSaver.saveAuthors(configuration, indentedPrinter);
            ConfigSaver.saveSystems(configuration, indentedPrinter);
            ConfigSaver.saveCartMenus(configuration, indentedPrinter);
            ConfigSaver.saveGames(configuration, indentedPrinter);
            ConfigSaver.closeSection(indentedPrinter, "configuration");
        }
        finally {
            printStream.close();
        }
        return true;
    }

    public static final void saveXmlHeader(IndentedPrinter indentedPrinter) {
        indentedPrinter.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        indentedPrinter.println();
    }

    public static final void saveWindow(Configuration configuration, IndentedPrinter indentedPrinter) throws IOException {
        StringBuilder stringBuilder = new StringBuilder("<window");
        Rectangle rectangle = configuration.window;
        CfgItemOptions cfgItemOptions = configuration.options;
        ConfigSaver.appendAttribute(stringBuilder, "x", rectangle.x);
        ConfigSaver.appendAttribute(stringBuilder, "y", rectangle.y);
        ConfigSaver.appendAttribute(stringBuilder, "width", rectangle.width);
        ConfigSaver.appendAttribute(stringBuilder, "height", rectangle.height);
        ConfigSaver.appendAttribute(stringBuilder, "fullscreen", cfgItemOptions.display_fullscreen);
        ConfigSaver.appendAttribute(stringBuilder, "state", configuration.windowMaxState);
        ConfigSaver.appendAttribute(stringBuilder, "menuBar", cfgItemOptions.menuVisible ? "on" : "off");
        indentedPrinter.println(stringBuilder.append(" />"));
    }

    public static final void saveTiming(Configuration configuration, IndentedPrinter indentedPrinter) throws IOException {
        CfgItemTiming cfgItemTiming = configuration.timing;
        StringBuilder stringBuilder = new StringBuilder("<timing");
        ConfigSaver.appendAttribute(stringBuilder, "method", cfgItemTiming.getMethodID());
        switch (cfgItemTiming.method) {
            case 0: {
                ConfigSaver.appendAttribute(stringBuilder, "fps", cfgItemTiming.fps);
                ConfigSaver.appendAttribute(stringBuilder, "nanos", cfgItemTiming.useNano);
                break;
            }
            case 1: {
                ConfigSaver.appendAttribute(stringBuilder, "delay", cfgItemTiming.nsDelay);
            }
        }
        indentedPrinter.println(stringBuilder.append(" />"));
    }

    public static final void saveOptions(Configuration configuration, IndentedPrinter indentedPrinter) throws IOException {
        CfgItemOptions cfgItemOptions = configuration.options;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<sound");
        ConfigSaver.appendAttribute(stringBuilder, "enabled", cfgItemOptions.snd_enabled);
        ConfigSaver.appendAttribute(stringBuilder, "createThread", cfgItemOptions.snd_createThread);
        ConfigSaver.appendAttribute(stringBuilder, "samplingRate", cfgItemOptions.snd_samplingFreq);
        ConfigSaver.appendAttribute(stringBuilder, "volume", cfgItemOptions.snd_volume);
        indentedPrinter.println(stringBuilder.append(" />"));
        stringBuilder.setLength(0);
        stringBuilder.append("<debug");
        ConfigSaver.appendAttribute(stringBuilder, "showFps", cfgItemOptions.showFps);
        ConfigSaver.appendAttribute(stringBuilder, "debugFeatures", cfgItemOptions.debugMode);
        ConfigSaver.appendAttribute(stringBuilder, "devMode", DevOptions.devMode);
        indentedPrinter.println(stringBuilder.append(" />"));
    }

    public static final void saveOverall(Configuration configuration, IndentedPrinter indentedPrinter) throws IOException {
        CfgItemOptions cfgItemOptions = configuration.options;
        indentedPrinter.println();
        ConfigSaver.openSection(indentedPrinter, "overall");
        ConfigSaver.saveOverallOption(indentedPrinter, "firstRun", false);
        ConfigSaver.saveOverallOption(indentedPrinter, "toggleMenuHelp", cfgItemOptions.hideMenuHelp);
        ConfigSaver.saveOverallFolder(indentedPrinter, "saves", cfgItemOptions.lastPathUserSaves);
        ConfigSaver.saveOverallFolder(indentedPrinter, "snapshots", cfgItemOptions.lastPathSnapshots);
        ConfigSaver.saveOverallFolder(indentedPrinter, "injection", cfgItemOptions.lastPathInjections);
        ConfigSaver.closeSection(indentedPrinter, "overall");
    }

    public static final void saveDisplay(Configuration configuration, IndentedPrinter indentedPrinter) throws IOException {
        CfgItemOptions cfgItemOptions = configuration.options;
        StringBuilder stringBuilder = new StringBuilder();
        indentedPrinter.println();
        stringBuilder.append("<display");
        ConfigSaver.appendAttribute(stringBuilder, "aa", cfgItemOptions.display_antialiasing);
        ConfigSaver.appendAttribute(stringBuilder, "persistent", cfgItemOptions.display_persistence);
        ConfigSaver.appendAttribute(stringBuilder, "additive", cfgItemOptions.display_additive_blend);
        ConfigSaver.appendAttribute(stringBuilder, "overlay", cfgItemOptions.display_overlay);
        ConfigSaver.appendAttribute(stringBuilder, "overlayMode", cfgItemOptions.display_overlay_mode);
        ConfigSaver.appendAttribute(stringBuilder, "rotation", cfgItemOptions.display_rotation);
        ConfigSaver.appendAttribute(stringBuilder, "gamma", cfgItemOptions.display_gamma);
        ConfigSaver.appendAttribute(stringBuilder, "brightness", (int)(100.0f / cfgItemOptions.display_brightness));
        indentedPrinter.println(stringBuilder.append('>'));
        indentedPrinter.push();
        ConfigSaver.saveVectorsOptions(cfgItemOptions, indentedPrinter);
        ConfigSaver.saveChassisOptions(cfgItemOptions, indentedPrinter);
        ConfigSaver.saveShaders(configuration, indentedPrinter);
        ConfigSaver.closeSection(indentedPrinter, "display");
        indentedPrinter.println();
    }

    public static final void saveKeyMapping(Configuration configuration, IndentedPrinter indentedPrinter) throws IOException {
        ConfigSaver.openSection(indentedPrinter, "keymapping");
        CfgItemKeymapping cfgItemKeymapping = configuration.keyMapping;
        ConfigSaver.saveBind(indentedPrinter, "exit", cfgItemKeymapping.keyExit);
        ConfigSaver.saveBind(indentedPrinter, "menu", cfgItemKeymapping.keyMenu);
        ConfigSaver.saveBind(indentedPrinter, "size", cfgItemKeymapping.keySizeOptim);
        ConfigSaver.saveBind(indentedPrinter, "pause", cfgItemKeymapping.keyPause);
        ConfigSaver.saveBind(indentedPrinter, "reset", cfgItemKeymapping.keyReset);
        ConfigSaver.saveBind(indentedPrinter, "screenshot", cfgItemKeymapping.keySnapShot);
        ConfigSaver.saveBind(indentedPrinter, "save", cfgItemKeymapping.keySave);
        ConfigSaver.saveBind(indentedPrinter, "load", cfgItemKeymapping.keyLoad);
        ConfigSaver.saveBind(indentedPrinter, "quicksave", cfgItemKeymapping.keyQuickSave);
        ConfigSaver.saveBind(indentedPrinter, "quickload", cfgItemKeymapping.keyQuickLoad);
        ConfigSaver.saveJoyMapping(cfgItemKeymapping.joy1, "joy1", indentedPrinter);
        ConfigSaver.saveJoyMapping(cfgItemKeymapping.joy2, "joy2", indentedPrinter);
        ConfigSaver.saveDeviceMapping(cfgItemKeymapping.keyboard, "KEYBOARD", indentedPrinter);
        ConfigSaver.saveMouseMapping(cfgItemKeymapping.analogMouseSensitivity, indentedPrinter);
        ConfigSaver.closeSection(indentedPrinter, "keymapping");
        indentedPrinter.println();
    }

    public static final void saveChassisOptions(CfgItemOptions cfgItemOptions, IndentedPrinter indentedPrinter) throws IOException {
        CfgItemChassis cfgItemChassis = cfgItemOptions.chassis;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<chassis");
        ConfigSaver.appendAttribute(stringBuilder, "enabled", cfgItemChassis.enabled);
        ConfigSaver.appendAttribute(stringBuilder, "zoom", cfgItemChassis.zoom);
        ConfigSaver.appendAttribute(stringBuilder, "tx", cfgItemChassis.xOffset);
        ConfigSaver.appendAttribute(stringBuilder, "ty", cfgItemChassis.yOffset);
        indentedPrinter.println(stringBuilder.append('>'));
        indentedPrinter.push();
        ConfigSaver.saveChassisPart(stringBuilder, indentedPrinter, "frame", cfgItemChassis.enableFrame);
        ConfigSaver.saveChassisPart(stringBuilder, indentedPrinter, "port1", cfgItemChassis.enablePort1);
        ConfigSaver.saveChassisPart(stringBuilder, indentedPrinter, "port2", cfgItemChassis.enablePort2);
        ConfigSaver.saveChassisPart(stringBuilder, indentedPrinter, "screen", cfgItemChassis.enableScreen);
        ConfigSaver.saveChassisPart(stringBuilder, indentedPrinter, "holders", cfgItemChassis.enableHolders);
        ConfigSaver.saveChassisPart(stringBuilder, indentedPrinter, "bayPanel", cfgItemChassis.enablePanel);
        ConfigSaver.saveChassisPart(stringBuilder, indentedPrinter, "cartridge", cfgItemChassis.enableCartridge);
        ConfigSaver.closeSection(indentedPrinter, "chassis");
    }

    public static final void saveChassisPart(StringBuilder stringBuilder, IndentedPrinter indentedPrinter, String string, boolean bl) throws IOException {
        stringBuilder.setLength(0);
        stringBuilder.append("<part");
        ConfigSaver.appendAttribute(stringBuilder, "id", string);
        ConfigSaver.appendAttribute(stringBuilder, "enabled", bl);
        indentedPrinter.println(stringBuilder.append(" />"));
    }

    public static final void saveVectorsOptions(CfgItemOptions cfgItemOptions, IndentedPrinter indentedPrinter) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        ConfigSaver.openSection(indentedPrinter, "vectors");
        stringBuilder.append("<thickness");
        ConfigSaver.appendAttribute(stringBuilder, "lines", cfgItemOptions.display_size_lines);
        ConfigSaver.appendAttribute(stringBuilder, "points", cfgItemOptions.display_size_points);
        indentedPrinter.println(stringBuilder.append(" />"));
        ConfigSaver.printFactor(indentedPrinter, stringBuilder, "wobbling", cfgItemOptions.display_wobbling, cfgItemOptions.display_wobbling_factor);
        ConfigSaver.closeSection(indentedPrinter, "vectors");
    }

    public static final void saveShaders(Configuration configuration, IndentedPrinter indentedPrinter) throws IOException {
        ConfigSaver.openSection(indentedPrinter, "shaders");
        ConfigSaver.saveGlowShader(configuration.options.glowShader, indentedPrinter, false);
        ConfigSaver.closeSection(indentedPrinter, "shaders");
    }

    public static final void saveGlowShader(CfgItemShaderGlow cfgItemShaderGlow, IndentedPrinter indentedPrinter, boolean bl) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<shader");
        ConfigSaver.appendAttribute(stringBuilder, "id", "glow");
        ConfigSaver.appendAttribute(stringBuilder, "active", cfgItemShaderGlow.active);
        ConfigSaver.appendAttribute(stringBuilder, "passes", cfgItemShaderGlow.passes);
        indentedPrinter.println(stringBuilder.append('>'));
        indentedPrinter.push();
        stringBuilder.setLength(0);
        stringBuilder.append("<bufferSize");
        ConfigSaver.appendAttribute(stringBuilder, "fixed", cfgItemShaderGlow.isBufferFixedSize);
        ConfigSaver.appendAttribute(stringBuilder, "fixedWidth", cfgItemShaderGlow.bufferFixedWidth);
        ConfigSaver.appendAttribute(stringBuilder, "fixedHeight", cfgItemShaderGlow.bufferFixedHeight);
        ConfigSaver.appendAttribute(stringBuilder, "factor", cfgItemShaderGlow.bufferSizeFactor);
        indentedPrinter.println(stringBuilder.append(" />"));
        ConfigSaver.printFactor(indentedPrinter, stringBuilder, "flickering", cfgItemShaderGlow.flickering, cfgItemShaderGlow.flickeringFactor);
        ConfigSaver.printFactor(indentedPrinter, stringBuilder, "attenuation", cfgItemShaderGlow.attenuation, cfgItemShaderGlow.attenuationFactor);
        ConfigSaver.openSection(indentedPrinter, "gains");
        ConfigSaver.printFactor(indentedPrinter, stringBuilder, "horizontal", cfgItemShaderGlow.hGain, cfgItemShaderGlow.hGainFactor);
        ConfigSaver.printFactor(indentedPrinter, stringBuilder, "vertical", cfgItemShaderGlow.vGain, cfgItemShaderGlow.vGainFactor);
        ConfigSaver.closeSection(indentedPrinter, "gains");
        ConfigSaver.saveShaderKernel(cfgItemShaderGlow.getHorizonalKernel(), indentedPrinter);
        ConfigSaver.saveShaderKernel(cfgItemShaderGlow.getVerticalKernel(), indentedPrinter);
        if (bl) {
            ConfigSaver.openSection(indentedPrinter, "info");
            ConfigSaver.printCData(indentedPrinter, stringBuilder, "author", cfgItemShaderGlow.author);
            ConfigSaver.printCData(indentedPrinter, stringBuilder, "description", cfgItemShaderGlow.description);
            ConfigSaver.closeSection(indentedPrinter, "info");
        }
        ConfigSaver.closeSection(indentedPrinter, "shader");
    }

    public static final void saveShaderKernel(CfgItemKernel cfgItemKernel, IndentedPrinter indentedPrinter) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<kernel");
        ConfigSaver.appendAttribute(stringBuilder, "id", cfgItemKernel.getID());
        indentedPrinter.println(stringBuilder.append('>'));
        indentedPrinter.push();
        float[] fArray = cfgItemKernel.getHalfMatrix();
        int n = fArray.length;
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[n2];
            indentedPrinter.println("<value>" + f + "</value>");
            ++n2;
        }
        ConfigSaver.closeSection(indentedPrinter, "kernel");
    }

    public static final void saveControllers(Configuration configuration, IndentedPrinter indentedPrinter) throws IOException {
        CfgItemController[] cfgItemControllerArray = configuration.getControllers();
        StringBuilder stringBuilder = new StringBuilder("<controllers");
        ConfigSaver.appendAttribute(stringBuilder, "enabled", !configuration.isControllersDisabled());
        if (cfgItemControllerArray.length == 0) {
            indentedPrinter.println(stringBuilder.append(" />"));
            indentedPrinter.println();
            return;
        }
        indentedPrinter.println(stringBuilder.append('>'));
        indentedPrinter.push();
        int n = 0;
        while (n < cfgItemControllerArray.length) {
            ConfigSaver.saveController(cfgItemControllerArray[n], indentedPrinter);
            ++n;
        }
        ConfigSaver.closeSection(indentedPrinter, "controllers");
        indentedPrinter.println();
    }

    public static final void saveController(CfgItemController cfgItemController, IndentedPrinter indentedPrinter) throws IOException {
        if (CfgItemController.DirControl.UNDEFINED == cfgItemController.dirMode) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("<controller");
        ConfigSaver.appendAttribute(stringBuilder, "id", cfgItemController.getID());
        indentedPrinter.println(stringBuilder.append(">"));
        indentedPrinter.push();
        stringBuilder = new StringBuilder("<direction");
        switch (cfgItemController.dirMode) {
            case AXIS: {
                ConfigSaver.appendAttribute(stringBuilder, "mode", "axis");
                ConfigSaver.appendAttribute(stringBuilder, "horizontal", String.valueOf(cfgItemController.invertX ? "-" : "+") + cfgItemController.axisXID);
                ConfigSaver.appendAttribute(stringBuilder, "vertical", String.valueOf(cfgItemController.invertY ? "-" : "+") + cfgItemController.axisYID);
                break;
            }
            case BTNS: {
                ConfigSaver.appendAttribute(stringBuilder, "mode", "digital");
                ConfigSaver.appendAttribute(stringBuilder, "left", cfgItemController.leftID);
                ConfigSaver.appendAttribute(stringBuilder, "right", cfgItemController.rightID);
                ConfigSaver.appendAttribute(stringBuilder, "up", cfgItemController.upID);
                ConfigSaver.appendAttribute(stringBuilder, "down", cfgItemController.downID);
                break;
            }
            case POV: {
                ConfigSaver.appendAttribute(stringBuilder, "mode", "POV");
                ConfigSaver.appendAttribute(stringBuilder, "id", cfgItemController.povID);
            }
        }
        if (cfgItemController.sensitivity.isDefault() && cfgItemController.response.isDefault()) {
            indentedPrinter.println(stringBuilder.append(" />"));
        } else {
            indentedPrinter.println(stringBuilder.append('>'));
            indentedPrinter.push();
            ConfigSaver.saveSensitivity(cfgItemController.sensitivity, indentedPrinter, false);
            ConfigSaver.saveCurve(cfgItemController.response, indentedPrinter, "response");
            ConfigSaver.closeSection(indentedPrinter, "direction");
        }
        int n = 0;
        while (n < 4) {
            stringBuilder = new StringBuilder("<button");
            ConfigSaver.appendAttribute(stringBuilder, "index", n + 1);
            ConfigSaver.appendAttribute(stringBuilder, "id", cfgItemController.buttonID[n]);
            indentedPrinter.println(stringBuilder.append(" />"));
            ++n;
        }
        ConfigSaver.closeSection(indentedPrinter, "controller");
    }

    public static final void savePeripherals(Configuration configuration, IndentedPrinter indentedPrinter) throws IOException {
        ConfigSaver.openSection(indentedPrinter, "peripherals");
        int n = 0;
        while (n < configuration.portsDevices.length) {
            ConfigSaver.savePeripheral(configuration.portsDevices[n].getPersistentInstance(), n, false, indentedPrinter);
            ++n;
        }
        ConfigSaver.closeSection(indentedPrinter, "peripherals");
        indentedPrinter.println();
    }

    public static final void savePeripheral(CfgItemPeripheral cfgItemPeripheral, int n, boolean bl, IndentedPrinter indentedPrinter) throws IOException {
        String string = "gameport" + (n + 1);
        String string2 = cfgItemPeripheral.deviceID;
        StringBuilder stringBuilder = new StringBuilder(80).append('<');
        stringBuilder.append(bl ? "requirement" : "peripheral");
        ConfigSaver.appendAttribute(stringBuilder, "port", string);
        ConfigSaver.appendAttribute(stringBuilder, "device", string2);
        ConfigSaver.appendAttributes(stringBuilder, cfgItemPeripheral.attrs);
        indentedPrinter.println(stringBuilder.append(" />"));
    }

    public static final void saveCategories(Configuration configuration, IndentedPrinter indentedPrinter) throws IOException {
        if (configuration.categories.isEmpty()) {
            indentedPrinter.println("<categories/>");
            indentedPrinter.println();
            return;
        }
        CfgItemCategory cfgItemCategory = configuration.getDefaultCategory();
        StringBuilder stringBuilder = new StringBuilder("<categories");
        if (cfgItemCategory != null) {
            ConfigSaver.appendAttribute(stringBuilder, "default", cfgItemCategory.getID());
        }
        indentedPrinter.println(stringBuilder.append('>'));
        indentedPrinter.push();
        for (CfgItemCategory cfgItemCategory2 : configuration.categories) {
            stringBuilder = new StringBuilder("<category");
            ConfigSaver.appendAttribute(stringBuilder, "id", cfgItemCategory2.getID());
            ConfigSaver.appendAttribute(stringBuilder, "name", cfgItemCategory2.name);
            indentedPrinter.println(stringBuilder.append(" />"));
        }
        ConfigSaver.closeSection(indentedPrinter, "categories");
        indentedPrinter.println();
    }

    public static final void saveAuthors(Configuration configuration, IndentedPrinter indentedPrinter) throws IOException {
        if (configuration.authors.isEmpty()) {
            indentedPrinter.println("<authors/>");
            indentedPrinter.println();
            return;
        }
        CfgItemAuthor cfgItemAuthor = configuration.getDefaultAuthor();
        StringBuilder stringBuilder = new StringBuilder("<authors");
        if (cfgItemAuthor != null) {
            ConfigSaver.appendAttribute(stringBuilder, "default", cfgItemAuthor.getID());
        }
        indentedPrinter.println(stringBuilder.append('>'));
        indentedPrinter.push();
        for (CfgItemAuthor cfgItemAuthor2 : configuration.authors) {
            stringBuilder = new StringBuilder("<author");
            ConfigSaver.appendAttribute(stringBuilder, "id", cfgItemAuthor2.getID());
            ConfigSaver.appendAttribute(stringBuilder, "name", XmlUtils.xmlEncodeSpecialChars(cfgItemAuthor2.name));
            if (cfgItemAuthor2.url != null) {
                ConfigSaver.appendAttribute(stringBuilder, "url", cfgItemAuthor2.url);
            }
            indentedPrinter.println(stringBuilder.append(" />"));
        }
        ConfigSaver.closeSection(indentedPrinter, "authors");
        indentedPrinter.println();
    }

    public static final void saveSystems(Configuration configuration, IndentedPrinter indentedPrinter) throws IOException {
        CfgItemRom cfgItemRom = configuration.getDefaultSystemRom();
        StringBuilder stringBuilder = new StringBuilder("<systems");
        if (cfgItemRom != null) {
            ConfigSaver.appendAttribute(stringBuilder, "default", cfgItemRom.getID());
        }
        indentedPrinter.println(stringBuilder.append('>'));
        indentedPrinter.push();
        for (CfgItemRom cfgItemRom2 : configuration.systems) {
            stringBuilder = new StringBuilder("<rom");
            ConfigSaver.appendAttribute(stringBuilder, "id", cfgItemRom2.getID());
            ConfigSaver.appendAttribute(stringBuilder, "name", cfgItemRom2.name);
            ConfigSaver.appendPath(stringBuilder, "path", cfgItemRom2.path);
            indentedPrinter.println(stringBuilder.append(" />"));
        }
        ConfigSaver.closeSection(indentedPrinter, "systems");
        indentedPrinter.println();
    }

    public static final void saveCartMenus(Configuration configuration, IndentedPrinter indentedPrinter) throws IOException {
        if (configuration.bankMenus.isEmpty()) {
            indentedPrinter.println("<cartridgeMenus/>");
            indentedPrinter.println();
            return;
        }
        indentedPrinter.println("<cartridgeMenus>");
        indentedPrinter.push();
        for (CfgItemBankMenu cfgItemBankMenu : configuration.bankMenus) {
            StringBuilder stringBuilder = new StringBuilder("<cartridgeMenu");
            ConfigSaver.appendAttribute(stringBuilder, "id", cfgItemBankMenu.getID());
            ConfigSaver.appendAttribute(stringBuilder, "mode", cfgItemBankMenu.mode.getKey());
            ConfigSaver.appendAttribute(stringBuilder, "name", cfgItemBankMenu.name);
            ConfigSaver.appendPath(stringBuilder, "path", cfgItemBankMenu.path);
            ConfigSaver.appendAttribute(stringBuilder, "counterSize", cfgItemBankMenu.banksCounterSize);
            ConfigSaver.appendAttribute(stringBuilder, "namesSize", cfgItemBankMenu.banksNamesSize);
            indentedPrinter.println(stringBuilder.append(" />"));
        }
        ConfigSaver.closeSection(indentedPrinter, "cartridgeMenus");
        indentedPrinter.println();
    }

    public static final void saveGames(Configuration configuration, IndentedPrinter indentedPrinter) throws IOException {
        CfgItemGame cfgItemGame = configuration.getPickedGame();
        CfgItemGame cfgItemGame2 = configuration.getBuiltGame();
        CfgItemGame cfgItemGame3 = configuration.getSelectedGame();
        StringBuilder stringBuilder = new StringBuilder("<games");
        if (cfgItemGame3 != null) {
            ConfigSaver.appendAttribute(stringBuilder, "selected", cfgItemGame3.getID());
        }
        if (cfgItemGame != null) {
            ConfigSaver.appendPath(stringBuilder, "picked", ConfigSaver.encodeHtmlRelativePath(cfgItemGame.cartridge.getCartridgePath()));
        }
        if (cfgItemGame2 != null) {
            ConfigSaver.appendPath(stringBuilder, "source", ConfigSaver.encodeHtmlRelativePath(cfgItemGame2.cartridge.getCartridgePath()));
        }
        indentedPrinter.println(stringBuilder.append('>'));
        indentedPrinter.push();
        for (CfgItemGameContainer cfgItemGameContainer : configuration.games) {
            CfgItemOverlay cfgItemOverlay;
            Object object;
            if (cfgItemGameContainer.isSeparator()) {
                object = ConfigSaver.formatSeparator(cfgItemGameContainer.separator);
                if (object == null) continue;
                indentedPrinter.println();
                indentedPrinter.println((StringBuilder)object);
                continue;
            }
            object = cfgItemGameContainer.game;
            CfgItemCartridge cfgItemCartridge = ((CfgItemGame)object).cartridge;
            if (cfgItemCartridge.picked || cfgItemCartridge.built) continue;
            stringBuilder = new StringBuilder("<game");
            ConfigSaver.appendAttribute(stringBuilder, "id", ((CfgItemGame)object).getID());
            ConfigSaver.appendAttribute(stringBuilder, "name", cfgItemCartridge.getName());
            indentedPrinter.println();
            indentedPrinter.println(stringBuilder.append(">"));
            indentedPrinter.push();
            stringBuilder = new StringBuilder("<roms");
            ConfigSaver.appendAttribute(stringBuilder, "system", ((CfgItemGame)object).systemRomDefault ? "DEFAULT" : ((CfgItemGame)object).systemRom.getID());
            if (cfgItemCartridge.isComposite() || cfgItemCartridge.isZippedEntry()) {
                indentedPrinter.println(stringBuilder.append('>'));
                indentedPrinter.push();
                ConfigSaver.saveGameCartridge(cfgItemCartridge, indentedPrinter);
                ConfigSaver.closeSection(indentedPrinter, "roms");
            } else {
                ConfigSaver.appendPath(stringBuilder, "cartridge", cfgItemCartridge.getCartridgePath());
                indentedPrinter.println(stringBuilder.append(" />"));
            }
            if (((CfgItemGame)object).hasCartridgeRam()) {
                stringBuilder = new StringBuilder("<ram");
                ConfigSaver.appendAttribute(stringBuilder, "address", "$" + Utils.HEX4(cfgItemCartridge.cartridgeRAM.address));
                ConfigSaver.appendAttribute(stringBuilder, "size", "$" + Utils.HEX(3, cfgItemCartridge.cartridgeRAM.size));
                indentedPrinter.println(stringBuilder.append(" />"));
            }
            if (((CfgItemGame)object).hasHacks()) {
                stringBuilder = new StringBuilder("<hack");
                ConfigSaver.appendAttribute(stringBuilder, "enabled", ((CfgItemGame)object).hacks.isEnabled());
                ConfigSaver.appendAttribute(stringBuilder, "interlaced", ((CfgItemGame)object).hacks.isInterlaced());
                if (((CfgItemGame)object).hacks.hasRampDelay1()) {
                    ConfigSaver.appendAttribute(stringBuilder, "rampDelay1", ((CfgItemGame)object).hacks.getRampDelay1());
                }
                if (((CfgItemGame)object).hacks.hasRampDelay2()) {
                    ConfigSaver.appendAttribute(stringBuilder, "rampDelay2", ((CfgItemGame)object).hacks.getRampDelay2());
                }
                indentedPrinter.println(stringBuilder.append(" />"));
            }
            if (((CfgItemGame)object).hasRequirements()) {
                int n = 0;
                while (n < ((CfgItemGame)object).requirements.length) {
                    if (((CfgItemGame)object).requirements[n] != null) {
                        ConfigSaver.savePeripheral(((CfgItemGame)object).requirements[n], n, true, indentedPrinter);
                    }
                    ++n;
                }
            }
            if (((CfgItemGame)object).info.hasInfo()) {
                stringBuilder = new StringBuilder("<info");
                CfgItemGameInfo cfgItemGameInfo = ((CfgItemGame)object).info;
                if (!cfgItemGameInfo.category.isDefault) {
                    ConfigSaver.appendAttribute(stringBuilder, "category", cfgItemGameInfo.category.getID());
                }
                if (!cfgItemGameInfo.author.isDefault) {
                    ConfigSaver.appendAttribute(stringBuilder, "author", cfgItemGameInfo.author.getID());
                }
                ConfigSaver.appendNonNullAttribute(stringBuilder, "version", cfgItemGameInfo.version);
                ConfigSaver.appendNonNullAttribute(stringBuilder, "date", cfgItemGameInfo.date);
                ConfigSaver.appendNonNullAttribute(stringBuilder, "doc", cfgItemGameInfo.docPath);
                ConfigSaver.appendNonNullAttribute(stringBuilder, "screenshot", cfgItemGameInfo.picPath);
                ConfigSaver.appendNonNullAttribute(stringBuilder, "comments", cfgItemGameInfo.comments);
                indentedPrinter.println(stringBuilder.append(" />"));
            }
            if (!(cfgItemOverlay = ((CfgItemGame)object).overlay).isDefault()) {
                stringBuilder = new StringBuilder("<overlay");
                ConfigSaver.appendAttribute(stringBuilder, "tx", cfgItemOverlay.tx);
                ConfigSaver.appendAttribute(stringBuilder, "ty", cfgItemOverlay.ty);
                ConfigSaver.appendAttribute(stringBuilder, "sx", cfgItemOverlay.sx);
                ConfigSaver.appendAttribute(stringBuilder, "sy", cfgItemOverlay.sy);
                ConfigSaver.appendAttribute(stringBuilder, "passes", cfgItemOverlay.passes);
                ConfigSaver.appendAttribute(stringBuilder, "mipmap", cfgItemOverlay.mipmap);
                ConfigSaver.appendPath(stringBuilder, "path", cfgItemOverlay.path);
                indentedPrinter.println(stringBuilder.append(" />"));
            }
            stringBuilder = new StringBuilder("<persistence");
            ConfigSaver.appendAttribute(stringBuilder, "enabled", ((CfgItemGame)object).persistence.enabled);
            ConfigSaver.appendAttribute(stringBuilder, "history", ((CfgItemGame)object).persistence.history);
            indentedPrinter.println(stringBuilder.append(" />"));
            stringBuilder = new StringBuilder("<shininess");
            ConfigSaver.appendAttribute(stringBuilder, "normal", ((CfgItemGame)object).shininess.normal);
            ConfigSaver.appendAttribute(stringBuilder, "blurred", ((CfgItemGame)object).shininess.blurred);
            indentedPrinter.println(stringBuilder.append(" />"));
            ConfigSaver.closeSection(indentedPrinter, "game");
        }
        indentedPrinter.println();
        ConfigSaver.closeSection(indentedPrinter, "games");
        indentedPrinter.println();
    }

    public static final void saveGameCartridge(CfgItemCartridge cfgItemCartridge, IndentedPrinter indentedPrinter) throws IOException {
        StringBuilder stringBuilder = new StringBuilder("<cartridge");
        if (cfgItemCartridge.isComposite()) {
            CfgItemCartridgeComposite cfgItemCartridgeComposite = (CfgItemCartridgeComposite)cfgItemCartridge;
            ConfigSaver.appendAttribute(stringBuilder, "bankMode", cfgItemCartridgeComposite.dualMode ? "DUAL" : "MULTI");
            if (cfgItemCartridgeComposite.hasMenu()) {
                ConfigSaver.appendAttribute(stringBuilder, "menu", cfgItemCartridgeComposite.menu.getID());
            }
            indentedPrinter.println(stringBuilder.append('>'));
            indentedPrinter.push();
            for (CfgItemCartridgePart cfgItemCartridgePart : cfgItemCartridgeComposite.banks) {
                stringBuilder = new StringBuilder("<bank");
                ConfigSaver.appendPath(stringBuilder, "path", cfgItemCartridgePart.cartridgePath);
                ConfigSaver.appendPath(stringBuilder, "zipPath", cfgItemCartridgePart.cartZipEntry);
                ConfigSaver.appendOption(stringBuilder, "label", cfgItemCartridgePart.loadedLabel);
                indentedPrinter.println(stringBuilder.append(" />"));
            }
            ConfigSaver.closeSection(indentedPrinter, "cartridge");
        } else {
            ConfigSaver.appendPath(stringBuilder, "path", cfgItemCartridge.getCartridgePath());
            ConfigSaver.appendPath(stringBuilder, "zipPath", cfgItemCartridge.getCartridgeZipPath());
            indentedPrinter.println(stringBuilder.append(" />"));
        }
    }

    public static final void saveMouseMapping(CfgItemSensitivity cfgItemSensitivity, IndentedPrinter indentedPrinter) throws IOException {
        ConfigSaver.openSection(indentedPrinter, "mouse");
        ConfigSaver.saveSensitivity(cfgItemSensitivity, indentedPrinter, true);
        ConfigSaver.closeSection(indentedPrinter, "mouse");
    }

    public static final void saveDeviceMapping(CfgItemKeySwitch cfgItemKeySwitch, String string, IndentedPrinter indentedPrinter) throws IOException {
        indentedPrinter.println("<device id=\"" + string + "\">");
        indentedPrinter.push();
        ConfigSaver.saveBind(indentedPrinter, "on", cfgItemKeySwitch.keyON);
        ConfigSaver.saveBind(indentedPrinter, "off", cfgItemKeySwitch.keyOFF);
        ConfigSaver.closeSection(indentedPrinter, "device");
    }

    public static final void saveJoyMapping(CfgItemJoystick cfgItemJoystick, String string, IndentedPrinter indentedPrinter) throws IOException {
        indentedPrinter.println("<joystick id=\"" + string + "\">");
        indentedPrinter.push();
        ConfigSaver.saveBind(indentedPrinter, "button1", cfgItemJoystick.keyBtn1);
        ConfigSaver.saveBind(indentedPrinter, "button2", cfgItemJoystick.keyBtn2);
        ConfigSaver.saveBind(indentedPrinter, "button3", cfgItemJoystick.keyBtn3);
        ConfigSaver.saveBind(indentedPrinter, "button4", cfgItemJoystick.keyBtn4);
        ConfigSaver.saveBind(indentedPrinter, "up", cfgItemJoystick.keyUp);
        ConfigSaver.saveBind(indentedPrinter, "down", cfgItemJoystick.keyDown);
        ConfigSaver.saveBind(indentedPrinter, "left", cfgItemJoystick.keyLeft);
        ConfigSaver.saveBind(indentedPrinter, "right", cfgItemJoystick.keyRight);
        ConfigSaver.closeSection(indentedPrinter, "joystick");
    }

    public static final void saveBind(IndentedPrinter indentedPrinter, String string, CfgItemKey cfgItemKey) throws IOException {
        String string2 = cfgItemKey.getString(false);
        if (string2 != null) {
            StringBuilder stringBuilder = new StringBuilder("<bind");
            ConfigSaver.appendAttribute(stringBuilder, "id", string);
            ConfigSaver.appendAttribute(stringBuilder, "key", string2);
            indentedPrinter.println(stringBuilder.append(" />"));
        }
    }

    public static final void saveOverallFolder(IndentedPrinter indentedPrinter, String string, String string2) throws IOException {
        if (string2 != null && string2.length() > 0) {
            StringBuilder stringBuilder = new StringBuilder("<folder");
            ConfigSaver.appendAttribute(stringBuilder, "id", string);
            ConfigSaver.appendAttribute(stringBuilder, "path", ConfigSaver.encodeHtmlRelativePath(string2));
            indentedPrinter.println(stringBuilder.append(" />"));
        }
    }

    public static final void saveOverallOption(IndentedPrinter indentedPrinter, String string, boolean bl) throws IOException {
        StringBuilder stringBuilder = new StringBuilder("<option");
        ConfigSaver.appendAttribute(stringBuilder, "id", string);
        ConfigSaver.appendAttribute(stringBuilder, "value", bl);
        indentedPrinter.println(stringBuilder.append(" />"));
    }

    public static final void saveCurve(CfgItemCurve cfgItemCurve, IndentedPrinter indentedPrinter, String string) throws IOException {
        if (cfgItemCurve.isDefault()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("<" + string);
        List<Point2D.Float> list = cfgItemCurve.getPoints();
        ConfigSaver.appendAttribute(stringBuilder, "active", cfgItemCurve.isActive());
        stringBuilder.append(list.isEmpty() ? " />" : ">");
        indentedPrinter.println(stringBuilder);
        if (!list.isEmpty()) {
            indentedPrinter.push();
            for (Point2D.Float float_ : list) {
                stringBuilder = new StringBuilder("<curve");
                ConfigSaver.appendAttribute(stringBuilder, "x", float_.x);
                ConfigSaver.appendAttribute(stringBuilder, "y", float_.y);
                indentedPrinter.println(stringBuilder.append(" />"));
            }
            indentedPrinter.pop();
            indentedPrinter.println("</" + string + ">");
        }
    }

    public static final void saveSensitivity(CfgItemSensitivity cfgItemSensitivity, IndentedPrinter indentedPrinter, boolean bl) throws IOException {
        if (!bl && cfgItemSensitivity.isDefault()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("<sensitivity");
        ConfigSaver.appendAttribute(stringBuilder, "horizontal", cfgItemSensitivity.axisX);
        ConfigSaver.appendAttribute(stringBuilder, "vertical", cfgItemSensitivity.axisY);
        indentedPrinter.println(stringBuilder.append(" />"));
    }

    private static final void openSection(IndentedPrinter indentedPrinter, String string) {
        indentedPrinter.println("<" + string + ">");
        indentedPrinter.push();
    }

    private static final void closeSection(IndentedPrinter indentedPrinter, String string) {
        indentedPrinter.pop();
        indentedPrinter.println("</" + string + ">");
    }

    private static final void printCData(IndentedPrinter indentedPrinter, StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.setLength(0);
        ConfigSaver.appendCData(stringBuilder, string, string2);
        indentedPrinter.println(stringBuilder);
    }

    private static final void printFactor(IndentedPrinter indentedPrinter, StringBuilder stringBuilder, String string, boolean bl, float f) {
        stringBuilder.setLength(0);
        ConfigSaver.appendFactor(stringBuilder, string, bl, f);
        indentedPrinter.println(stringBuilder);
    }

    private static final void appendCData(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append('<').append(string);
        if (string2 == null || string2.length() == 0) {
            stringBuilder.append(" />");
        } else {
            stringBuilder.append('>');
            XmlUtils.xmlEncodeCDATA(string2, stringBuilder);
            stringBuilder.append("</").append(string).append('>');
        }
    }

    private static final StringBuilder appendFactor(StringBuilder stringBuilder, String string, boolean bl, float f) {
        stringBuilder.append('<').append(string);
        ConfigSaver.appendAttribute(stringBuilder, "enabled", bl);
        ConfigSaver.appendAttribute(stringBuilder, "factor", f);
        return stringBuilder.append(" />");
    }

    private static final void appendNonNullAttribute(StringBuilder stringBuilder, String string, String string2) {
        if (string2 != null) {
            ConfigSaver.appendAttribute(stringBuilder, string, string2);
        }
    }

    private static final void appendAttribute(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append(' ').append(string).append("=\"").append(string2).append('\"');
    }

    private static final void appendAttribute(StringBuilder stringBuilder, String string, float f) {
        stringBuilder.append(' ').append(string).append("=\"").append(f).append('\"');
    }

    private static final void appendAttribute(StringBuilder stringBuilder, String string, int n) {
        stringBuilder.append(' ').append(string).append("=\"").append(n).append('\"');
    }

    private static final void appendAttribute(StringBuilder stringBuilder, String string, boolean bl) {
        stringBuilder.append(' ').append(string).append("=\"").append(bl).append('\"');
    }

    private static final void appendAttributes(StringBuilder stringBuilder, AttributesMap attributesMap) {
        if (attributesMap != null) {
            for (String string : attributesMap.keySet()) {
                ConfigSaver.appendNonNullAttribute(stringBuilder, string, (String)attributesMap.get(string));
            }
        }
    }

    private static final void appendPath(StringBuilder stringBuilder, String string, String string2) {
        if (string2 != null && !"".equals(string2.trim())) {
            stringBuilder.append(' ').append(string).append("=\"");
            stringBuilder.append(ConfigSaver.normalizePath(string2));
            stringBuilder.append('\"');
        }
    }

    private static final void appendOption(StringBuilder stringBuilder, String string, String string2) {
        if (string2 != null && string2.trim().length() > 0) {
            stringBuilder.append(' ').append(string).append("=\"").append(string2).append('\"');
        }
    }

    private static final StringBuilder formatSeparator(CfgItemSeparator cfgItemSeparator) {
        if (!cfgItemSeparator.isVolatile) {
            StringBuilder stringBuilder = new StringBuilder("<separator");
            ConfigSaver.appendAttribute(stringBuilder, "label", cfgItemSeparator.label);
            if (cfgItemSeparator.color != null) {
                Color color = cfgItemSeparator.color;
                StringBuilder stringBuilder2 = new StringBuilder(7).append('#');
                Utils.HEX2(color.getRed(), stringBuilder2);
                Utils.HEX2(color.getGreen(), stringBuilder2);
                Utils.HEX2(color.getBlue(), stringBuilder2);
                ConfigSaver.appendAttribute(stringBuilder, "color", stringBuilder2.toString());
            }
            return stringBuilder.append(" />");
        }
        return null;
    }

    private static final String encodeHtmlRelativePath(String string) {
        String string2 = ConfigSaver.normalizePath(Utils.getRelativePath(string));
        return XmlUtils.xmlEncodeSpecialChars(string2);
    }

    private static final String normalizePath(String string) {
        return string == null ? null : string.replace('\\', '/');
    }
}

